<!-- Main content -->
<x-admin.contents>
    <x-slot:title>{{ $data['title'] }}</x-slot:title>
    <x-slot:menuOpen>{{ $data['menuOpen'] }} </x-slot:menuOpen>
    <x-slot:menuActive>{{ $data['menuActive'] }} </x-slot:menuActive>
    <x-slot:page>{{ $data['page'] }}</x-slot:page>
    <x-slot:head>
        <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
        <link rel="stylesheet"
            href="{{ asset('assets/admin/') }}/plugins/overlayScrollbars/css/OverlayScrollbars.min.css">

    </x-slot:head>


    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12 col-sm-6 col-md-3">
                    <div class="info-box">
                        <span class="info-box-icon bg-danger elevation-1"><i class="ion ion-bag"></i></span>

                        <div class="info-box-content">
                            <span class="info-box-text">Order Online</span>
                            <span class="info-box-number" id="order">
                                0
                                <small></small>
                            </span>
                        </div>
                        <!-- /.info-box-content -->
                    </div>
                    <!-- /.info-box -->
                </div>
                <!-- /.col -->

                <!-- /.col -->

                <!-- fix for small devices only -->
                <div class="clearfix hidden-md-up"></div>

                <div class="col-12 col-sm-6 col-md-3">
                    <div class="info-box mb-3">
                        <span class="info-box-icon bg-warning elevation-1"><i class="fas fa-shopping-cart"></i></span>

                        <div class="info-box-content">
                            <span class="info-box-text">Transaksi</span>
                            <span class="info-box-number" id="transaksi">0</span>
                        </div>
                        <!-- /.info-box-content -->
                    </div>
                    <!-- /.info-box -->
                </div>

                <div class="col-12 col-sm-6 col-md-3">
                    <div class="info-box mb-3">
                        <span class="info-box-icon bg-info elevation-1"><i class="fas fa-cubes"></i></span>

                        <div class="info-box-content">
                            <span class="info-box-text">Produk Terjual</span>
                            <span class="info-box-number" id="produk">0</span>
                        </div>
                        <!-- /.info-box-content -->
                    </div>
                    <!-- /.info-box -->
                </div>


                <!-- /.col -->
                <div class="col-12 col-sm-6 col-md-3">
                    <div class="info-box mb-3">
                        <span class="info-box-icon bg-primary elevation-1"><i class="fas fa-users"></i></span>

                        <div class="info-box-content">
                            <span class="info-box-text">Member Order</span>
                            <span class="info-box-number" id="member">0</span>
                        </div>
                        <!-- /.info-box-content -->
                    </div>
                    <!-- /.info-box -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->

            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header bg-warning">
                            <h5 class="card-title">Grafik Penjualan
                            </h5>


                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-8">
                                    <p class="text-center">
                                        <strong id="dttran"></strong>
                                    </p>

                                    <div class="chart">
                                        <!-- Sales Chart Canvas -->
                                        <canvas id="salesChart" height="210" style="height: 210px;"></canvas>
                                    </div>
                                    <!-- /.chart-responsive -->
                                </div>
                                <!-- /.col -->
                                <div class="col-md-4">
                                    <p class="text-center">
                                        <strong>5 Produk Terlaris</strong>
                                    </p>

                                    <div id="produk_terlaris"></div>

                                    <!-- /.progress-group -->
                                </div>
                                <!-- /.col -->
                            </div>
                            <!-- /.row -->
                        </div>
                        <!-- ./card-body -->
                        <div class="card-footer bg-dark">
                            <div class="row">
                                <div class="col-sm-3 col-6">
                                    <div class="description-block border-right">

                                        <h5 class="description-header" id="ttlp">Rp. 0</h5>
                                        <span class="description-text">TOTAL PENDAPATAN</span>
                                    </div>
                                    <!-- /.description-block -->
                                </div>
                                <!-- /.col -->
                                <div class="col-sm-3 col-6">
                                    <div class="description-block border-right">

                                        <h5 class="description-header" id="ttlpg">Rp. 0</h5>
                                        <span class="description-text">TOTAL PENGELUARAN</span>
                                    </div>
                                    <!-- /.description-block -->
                                </div>
                                <!-- /.col -->
                                <div class="col-sm-3 col-6">
                                    <div class="description-block border-right">

                                        <h5 class="description-header" id="ttlpr">Rp. 0</h5>
                                        <span class="description-text">TOTAL PROFIT</span>
                                    </div>
                                    <!-- /.description-block -->
                                </div>
                                <!-- /.col -->
                                <div class="col-sm-3 col-6">
                                    <div class="description-block">
                                        <h5 class="description-header" id="rata">Rp. 0</h5>
                                        <span class="description-text">PENDAPATAN RATA-RATA</span>
                                    </div>
                                    <!-- /.description-block -->
                                </div>
                            </div>
                            <!-- /.row -->
                        </div>
                        <!-- /.card-footer -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->

            <div class="row">
                <!-- Left col -->
                <div class="col-md-12">
                    <!-- MAP & BOX PANE -->

                    <!-- /.card -->
                    <div class="row">
                        <div class="col-md-4">
                            <!-- DIRECT CHAT -->
                            <div class="card">
                                <div class="card-header bg-danger">
                                    <h3 class="card-title">Pesan Terbaru</h3>

                                </div>
                                <!-- /.card-header -->
                                <div class="card-body p-0">
                                    <ul class="products-list product-list-in-card pl-2 pr-2">
                                        @forelse ($pesan as $p)
                                            <li class="item">
                                                <div class="product-img text-danger">
                                                    <i class="fa fa-envelope fa-3x"></i>
                                                </div>
                                                <div class="product-info">
                                                    <a href="/pesan" class="product-title">{{ $p->nama }}
                                                        <span
                                                            class="badge badge-warning float-right">{{ $p->email }}</span></a>
                                                    <span class="product-description">
                                                        {{ tgl_inf($p->created_at) }}
                                                    </span>
                                                </div>
                                            </li>
                                        @empty
                                        @endforelse

                                    </ul>
                                </div>
                                <!-- /.card-body -->
                                <div class="card-footer text-center">
                                    <a href="/pesan" class="uppercase">View All Pesan</a>
                                </div>
                                <!-- /.card-footer -->
                            </div>
                            <!--/.direct-chat -->
                        </div>
                        <!-- /.col -->

                        <div class="col-md-4">
                            <!-- USERS LIST -->
                            <div class="card">
                                <div class="card-header bg-secondary">
                                    <h3 class="card-title">Member Terbaru</h3>

                                </div>
                                <!-- /.card-header -->
                                <div class="card-body p-0">
                                    <ul class="products-list product-list-in-card pl-2 pr-2">
                                        @forelse ($member as  $m)
                                            @if ($m->kd_member == 0)
                                            @else
                                                <li class="item">
                                                    <div class="product-img text-danger">
                                                        <i class="fa fa-user-circle fa-3x "></i>
                                                    </div>
                                                    <div class="product-info">
                                                        <a href="/data-member"
                                                            class="product-title">{{ $m->nm_member }}
                                                            <span
                                                                class="badge badge-warning float-right">{{ $m->kelamin_member == 'L' ? 'Laki-Laki' : 'Perempuan' }}</span></a>
                                                        <span class="product-description">
                                                            {{ tgl_inf($m->created_at) }}
                                                        </span>
                                                    </div>
                                                </li>
                                            @endif
                                        @empty
                                        @endforelse

                                    </ul>
                                </div>
                                <!-- /.card-body -->
                                <div class="card-footer text-center">
                                    <a href="/data-member" class="uppercase">View All Member</a>
                                </div>
                                <!-- /.card-footer -->
                            </div>
                            <!--/.card -->
                        </div>
                        <!-- /.col -->

                        <div class="col-md-4">
                            <!-- Info Boxes Style 2 -->
                            <div class="card">
                                <div class="card-header bg-info">
                                    <h3 class="card-title">Member Teroyal</h3>


                                </div>
                                <!-- /.card-header -->
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-8">
                                            <div class="chart-responsive">
                                                <canvas id="pieChart" height="250"></canvas>
                                            </div>
                                            <!-- ./chart-responsive -->
                                        </div>
                                        <!-- /.col -->
                                        <div class="col-md-4">
                                            <ul class="chart-legend clearfix" id="nmmember2">

                                            </ul>
                                        </div>
                                        <!-- /.col -->
                                    </div>
                                    <!-- /.row -->
                                </div>
                                <!-- /.card-body -->
                                <div class="card-footer p-0">
                                    <br>
                                    <br>
                                </div>
                                <!-- /.footer -->
                            </div>
                            <!-- /.card -->

                            <!-- PRODUCT LIST -->

                            <!-- /.card -->
                        </div>
                    </div>
                    <!-- /.row -->

                    <!-- TABLE: LATEST ORDERS -->

                    <!-- /.card -->
                </div>
                <!-- /.col -->


                <!-- /.col -->

                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header border-transparent bg-dark">
                            <h3 class="card-title"> Order Terbaru</h3>


                        </div>
                        <!-- /.card-header -->
                        <div class="card-body p-0">
                            <div class="table-responsive">
                                <table class="table m-0">
                                    <thead>
                                        <tr>
                                            <th>NO. Transaksi</th>
                                            <th>Member</th>
                                            <th>Order</th>
                                            <th>Status</th>
                                            <th>Tanggal</th>
                                            <th>Total</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse ($transaksi as $t)
                                            <tr>
                                                <td><a href="#">{{ $t->kd_transaksi }}</a></td>
                                                <td>{{ $t->member->nm_member }}</td>
                                                <td>
                                                    {!! $t->jns_transaksi == 'ON'
                                                        ? '<span class="badge badge-success">Online</span>'
                                                        : ' <span class="badge badge-danger">Offline</span>' !!}

                                                </td>
                                                <td>
                                                    @if ($t->sts_transaksi == 'Y')
                                                        <span class="badge badge-info">Masih dalam proses</span>
                                                    @elseif ($t->sts_transaksi == 'T')
                                                        <span class="badge badge-danger">Proses menunggu</span>
                                                    @else
                                                        <span class="badge badge-success">Success</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    {{ tgl_inf($t->created_at) }}
                                                </td>
                                                <td>
                                                    Rp. {{ number_format($t->total) }}
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="9" class="text-center">Transaksi masih kosong</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                            <!-- /.table-responsive -->
                        </div>
                        <!-- /.card-body -->
                        <div class="card-footer clearfix">
                            <a href="/penjualan" class="btn btn-sm btn-secondary float-right">View All
                                Orders</a>
                        </div>
                        <!-- /.card-footer -->
                    </div>
                </div>
            </div>

        </div>
    </section>

    <input type="hidden" name="" id="tahun_ini" value="{{ date('Y') }}">
    <x-slot:foot>
        <script src="{{ asset('assets/admin/') }}/plugins/chart.js/Chart.min.js"></script>
        <script src="{{ asset('assets/admin/') }}/dashboard.js"></script>

    </x-slot:foot>
</x-admin.contents>
